/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import noppes.npcs.LogWriter;
import noppes.npcs.api.INbt;
import noppes.npcs.api.entity.data.IDropNbtSet;
import noppes.npcs.api.wrapper.NBTWrapper;
import noppes.npcs.entity.data.DropSet;
import noppes.npcs.util.ValueUtil;

public class DropNbtSet
implements IDropNbtSet {
    public double chance;
    private final DropSet parent;
    public String path;
    public int type;
    public int typeList;
    String[] values;

    public DropNbtSet(DropSet ds) {
        this.parent = ds;
        this.path = "";
        this.values = new String[0];
        this.type = 0;
        this.typeList = 0;
        this.chance = 100.0;
    }

    public String checkValue(String value, int type) {
        switch (type) {
            case 0: {
                try {
                    boolean b = Boolean.parseBoolean(value);
                    return String.valueOf(b);
                }
                catch (Exception e) {
                    LogWriter.error(e);
                    break;
                }
            }
            case 1: {
                try {
                    byte b = Byte.parseByte(value);
                    return String.valueOf(b);
                }
                catch (Exception e) {
                    LogWriter.error(e);
                    break;
                }
            }
            case 2: {
                try {
                    short s = Short.parseShort(value);
                    return String.valueOf(s);
                }
                catch (Exception e) {
                    LogWriter.error(e);
                    break;
                }
            }
            case 3: {
                try {
                    int b = Integer.parseInt(value);
                    return String.valueOf(b);
                }
                catch (Exception e) {
                    LogWriter.error(e);
                    break;
                }
            }
            case 4: {
                try {
                    long l = Long.parseLong(value);
                    return String.valueOf(l);
                }
                catch (Exception e) {
                    LogWriter.error(e);
                    break;
                }
            }
            case 5: {
                try {
                    float f = Float.parseFloat(value);
                    return String.valueOf(f);
                }
                catch (Exception e) {
                    LogWriter.error(e);
                    break;
                }
            }
            case 6: {
                try {
                    double d = Double.parseDouble(value);
                    return String.valueOf(d);
                }
                catch (Exception e) {
                    LogWriter.error(e);
                    break;
                }
            }
            case 7: {
                String[] br = value.split(",");
                StringBuilder text = new StringBuilder();
                for (String str : br) {
                    try {
                        byte b = Byte.parseByte(str);
                        if (text.length() > 0) {
                            text.append(",");
                        }
                        text.append(String.valueOf(b));
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                }
                if (text.length() <= 0) break;
                return text.toString();
            }
            case 8: {
                return value;
            }
            case 9: {
                String[] br = value.split(",");
                StringBuilder text = new StringBuilder();
                for (String str : br) {
                    try {
                        String sc = this.checkValue(str, this.typeList);
                        if (sc == null) continue;
                        if (text.length() > 0) {
                            text.append(",");
                        }
                        text.append(sc);
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                }
                if (text.length() <= 0) break;
                return text.toString();
            }
            case 11: {
                String[] br = value.split(",");
                StringBuilder text = new StringBuilder();
                for (String str : br) {
                    try {
                        int i = Integer.parseInt(str);
                        if (text.length() > 0) {
                            if (type == this.type) {
                                text.append(",");
                            }
                            text.append(";");
                        }
                        text.append(i);
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                }
                if (text.length() <= 0) break;
                return text.toString();
            }
        }
        return null;
    }

    @Override
    public double getChance() {
        return (double)Math.round(this.chance * 10000.0) / 10000.0;
    }

    @Override
    public INbt getConstructoredTag(INbt nbt) {
        int idx;
        NBTTagCompound pos = nbt.getMCNBT();
        String key = this.path;
        if (this.path.contains(".")) {
            while (key.contains(".")) {
                String keyName = key.substring(0, key.indexOf("."));
                if (!pos.func_150297_b(keyName, 10)) {
                    pos.func_74782_a(keyName, (NBTBase)new NBTTagCompound());
                }
                pos = pos.func_74775_l(keyName);
                key = key.substring(key.indexOf(".") + 1);
            }
        }
        if ((idx = (int)((double)this.values.length * Math.random())) >= this.values.length) {
            idx = this.values.length - 1;
        }
        String value = this.values[idx];
        switch (this.type) {
            case 0: {
                pos.func_74757_a(key, Boolean.parseBoolean(value));
                break;
            }
            case 1: {
                pos.func_74774_a(key, Byte.parseByte(value));
                break;
            }
            case 2: {
                pos.func_74777_a(key, Short.parseShort(value));
                break;
            }
            case 3: {
                pos.func_74768_a(key, Integer.parseInt(value));
                break;
            }
            case 4: {
                pos.func_74772_a(key, Long.parseLong(value));
                break;
            }
            case 5: {
                pos.func_74776_a(key, Float.parseFloat(value));
                break;
            }
            case 6: {
                pos.func_74780_a(key, Double.parseDouble(value));
                break;
            }
            case 7: {
                String[] brs = value.split(",");
                byte[] br = new byte[brs.length];
                for (int i = 0; i < brs.length; ++i) {
                    br[i] = Byte.parseByte(brs[i]);
                }
                pos.func_74773_a(key, br);
                break;
            }
            case 8: {
                pos.func_74778_a(key, value);
                break;
            }
            case 9: {
                String[] brs = value.split(",");
                NBTTagList list = new NBTTagList();
                for (String br : brs) {
                    if (this.typeList == 3) {
                        list.func_74742_a((NBTBase)new NBTTagInt(Integer.parseInt(br)));
                        continue;
                    }
                    if (this.typeList == 5) {
                        list.func_74742_a((NBTBase)new NBTTagFloat(Float.parseFloat(br)));
                        continue;
                    }
                    if (this.typeList == 6) {
                        list.func_74742_a((NBTBase)new NBTTagDouble(Double.parseDouble(br)));
                        continue;
                    }
                    if (this.typeList == 8) {
                        list.func_74742_a((NBTBase)new NBTTagString(br));
                        continue;
                    }
                    if (this.typeList != 11) continue;
                    String[] ints = br.split(";");
                    int[] is = new int[ints.length];
                    for (int j = 0; j < ints.length; ++j) {
                        is[j] = Integer.parseInt(ints[j]);
                    }
                    list.func_74742_a((NBTBase)new NBTTagIntArray(is));
                }
                pos.func_74782_a(key, (NBTBase)list);
                break;
            }
            case 11: {
                String[] ints = value.split(",");
                int[] is = new int[ints.length];
                for (int i = 0; i < ints.length; ++i) {
                    is[i] = Integer.parseInt(ints[i]);
                }
                pos.func_74783_a(key, is);
                break;
            }
        }
        return new NBTWrapper(pos);
    }

    public String getKey() {
        String keyName = "";
        char c = '\u00a7';
        double ch = (double)Math.round(this.chance * 10.0) / 10.0;
        String chance = String.valueOf(ch).replace(".", ",");
        if (ch == (double)((int)ch)) {
            chance = String.valueOf((int)ch);
        }
        chance = chance + "%";
        keyName = keyName + c + "e" + chance;
        String key = this.path;
        if (this.path.contains(".")) {
            ArrayList<String> keys = new ArrayList<String>();
            String preKey = "";
            while (key.contains(".")) {
                preKey = key.substring(0, key.indexOf("."));
                keys.add(preKey);
                key = key.substring(key.indexOf(".") + 1);
            }
            String lastKey = key;
            keys.add(key);
            key = preKey + "." + lastKey;
            if (keys.size() > 2) {
                key = "..." + key;
            }
        }
        keyName = keyName + c + "r " + key;
        keyName = this.values.length == 0 ? keyName + c + "b=" + c + "7|" + c + "cNULL" + c + "7|" : (this.values.length == 1 ? keyName + c + "b=" + c + "7|" + c + "r" + this.values[0] + c + "7|" : keyName + c + "b=" + c + "7|" + c + "6" + this.values.length + c + "7|");
        keyName = keyName + c + "8 #" + this.toString().substring(this.toString().indexOf("@") + 1);
        return keyName;
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound nbtDS = new NBTTagCompound();
        nbtDS.func_74768_a("Type", this.type);
        nbtDS.func_74768_a("TypeList", this.typeList);
        nbtDS.func_74778_a("Path", this.path);
        nbtDS.func_74780_a("Chance", this.chance);
        NBTTagList vs = new NBTTagList();
        for (String s : this.values) {
            if (s == null) continue;
            vs.func_74742_a((NBTBase)new NBTTagString(s));
        }
        nbtDS.func_74782_a("Values", (NBTBase)vs);
        return nbtDS;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getTypeList() {
        return this.typeList;
    }

    @Override
    public String[] getValues() {
        return this.values;
    }

    public void load(NBTTagCompound nbtDS) {
        this.type = nbtDS.func_74762_e("Type");
        this.typeList = nbtDS.func_74762_e("TypeList");
        this.path = nbtDS.func_74779_i("Path");
        this.chance = nbtDS.func_74769_h("Chance");
        String[] vs = new String[nbtDS.func_150295_c("Values", 8).func_74745_c()];
        for (int i = 0; i < nbtDS.func_150295_c("Values", 8).func_74745_c(); ++i) {
            String ch = this.checkValue(nbtDS.func_150295_c("Values", 8).func_150307_f(i), this.type);
            if (ch == null) continue;
            vs[i] = ch;
        }
        this.values = vs;
    }

    @Override
    public void remove() {
        this.parent.removeDropNbt(this);
    }

    @Override
    public void setChance(double chance) {
        double newChance = ValueUtil.correctDouble(chance, 1.0E-4, 100.0);
        this.chance = (double)Math.round(newChance * 10000.0) / 10000.0;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void setType(int type) {
        if (type == 0 || type == 1 || type == 2 || type == 3 || type == 4 || type == 5 || type == 6 || type == 7 || type == 8 || type == 9 || type == 11) {
            this.type = type;
        }
    }

    @Override
    public void setTypeList(int type) {
        if (type == 3 || type == 5 || type == 6 || type == 8 || type == 11) {
            this.typeList = type;
        }
    }

    @Override
    public void setValues(String values) {
        if (values.contains("|")) {
            ArrayList<String> nal = new ArrayList<String>();
            while (values.contains("|")) {
                String key = this.checkValue(values.substring(0, values.indexOf("|")), this.type);
                if (key != null) {
                    nal.add(key);
                }
                values = values.substring(values.indexOf("|") + 1);
            }
            nal.add(values);
            String[] svs = new String[nal.size()];
            for (int i = 0; i < nal.size(); ++i) {
                svs[i] = (String)nal.get(i);
            }
            this.values = svs;
        } else {
            String ch = this.checkValue(values, this.type);
            if (ch != null) {
                this.values = new String[]{ch};
            }
        }
    }

    @Override
    public void setValues(String[] values) {
        ArrayList<String> nal = new ArrayList<String>();
        for (String str : values) {
            String key = this.checkValue(str, this.type);
            if (key == null) continue;
            nal.add(key);
        }
        String[] svs = new String[nal.size()];
        for (int i = 0; i < nal.size(); ++i) {
            svs[i] = (String)nal.get(i);
        }
        this.values = svs;
    }
}

